#include <iostream>
#include <stdint.h>

[[gnu::hot]]
uint64_t msb(uint64_t n) noexcept {
	if (n == 0) return -1;
	return 31 - __builtin_clz(n); 
	// clz je count leading zeroes, ako 
	// oduzmemo broj bitova u int32 dobijamo
	// poziciju ispred prve jedinice
}

constexpr int32_t MAX_N = 200010;
constexpr	int32_t MAX_BIT = 33;

uint64_t prefix[MAX_BIT][MAX_N];

int main() noexcept {
	std::ios::sync_with_stdio(false);
	std::cin.tie(nullptr);
	std::cout.tie(nullptr);
	std::cerr.tie(nullptr);

	int64_t n, q, i, j, input, input_msb, l, r, k_max, k_curr;

	std::cin >> n >> q;
	for(i = 1; i <= n; ++i) {
		std::cin >> input;
		input_msb = msb(input);

		// uzimamo prethodne vrednosti iz prefix sume
		for(j = 0; j < MAX_BIT; ++j)
			prefix[j][i] = prefix[j][i-1];

		// brojimo frekvencije
		if (input_msb != -1) // provera za sve nule
			++prefix[input_msb][i];
	}

	while(q--) {
		std::cin >> l >> r;
		k_max = 0;

		for(j = 0; j < MAX_BIT; ++j) {
			k_curr = prefix[j][r] - prefix[j][l-1];
			k_max = (k_curr > k_max)? k_curr : k_max;
		}

		std::cout << k_max << '\n';
	}
}